/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.core.v2_1.graphics;

import com.roguewave.chart.core.v2_1.graphics.Point3D;
import com.roguewave.chart.core.v2_1.graphics.Transform3D;
import java.awt.Color;
import java.io.Serializable;

public class Polygon3D
implements Serializable {
    private int sides_;
    private int points_;
    private Point3D[] vertices_;
    private Color color_;
    private boolean outlineHighlight_;

    public Polygon3D(int n) {
        this.sides_ = n;
        this.points_ = 0;
        this.vertices_ = new Point3D[n];
        this.color_ = Color.black;
        this.outlineHighlight_ = true;
    }

    public Polygon3D(int n, Color color) {
        this.sides_ = n;
        this.points_ = 0;
        this.vertices_ = new Point3D[n];
        this.color_ = color;
        this.outlineHighlight_ = true;
    }

    public void addPoint(Point3D point3D) {
        if (this.points_ < this.sides_) {
            this.vertices_[this.points_++] = point3D;
            return;
        }
        throw new ArrayIndexOutOfBoundsException("Polygon3D.addPoint: number of vertices > number of sides");
    }

    public Color getColor() {
        return this.color_;
    }

    public boolean getOutlines() {
        return this.outlineHighlight_;
    }

    public Point3D getPoint(int n) {
        return this.vertices_[n];
    }

    public int sides() {
        return this.sides_;
    }

    public int points() {
        return this.points_;
    }

    public void setColor(Color color) {
        this.color_ = color;
    }

    public void setOutlines(boolean bl) {
        this.outlineHighlight_ = bl;
    }

    public String toString() {
        String string = this.vertices_[0].toString();
        int n = 0;
        while (n < this.points_) {
            string = ", " + string + this.vertices_[n];
            ++n;
        }
        return string;
    }

    public Polygon3D transform(Transform3D transform3D) {
        Polygon3D polygon3D = new Polygon3D(this.points_, this.color_);
        int n = 0;
        while (n < this.points_) {
            polygon3D.addPoint(transform3D.transform(this.vertices_[n]));
            ++n;
        }
        return polygon3D;
    }

    public Polygon3D zeroZ() {
        Polygon3D polygon3D = new Polygon3D(this.points_, this.color_);
        int n = 0;
        while (n < this.points_) {
            polygon3D.addPoint(new Point3D(this.vertices_[n].X(), this.vertices_[n].Y(), 0.0));
            ++n;
        }
        polygon3D.setOutlines(this.outlineHighlight_);
        return polygon3D;
    }
}

